@echo off
setlocal

set SCRIPT_DIR=%~dp0
cd /d "%SCRIPT_DIR%"

echo ================================================
echo   SMUL Personal - Factory Reset
echo ================================================
echo.
echo ADVERTENCIA: Esta operacion eliminara TODOS los datos
echo incluyendo bases de datos y volumenes de Docker!
echo ================================================
echo.

docker --version >nul 2>&1
if errorlevel 1 (
    echo ERROR: Docker no está instalado o no está ejecutándose!
    echo Por favor instala Docker Desktop y asegúrate de que esté ejecutándose.
    echo.
    pause
    exit /b 1
)

if not exist "docker-compose-run.yml" (
    echo ERROR: docker-compose-run.yml no encontrado!
    echo Por favor asegúrate de ejecutar este script desde el directorio correcto.
    echo.
    pause
    exit /b 1
)

set /p CONFIRM="¿Estás seguro de que quieres continuar? (escriba 'SI' para confirmar): "
if /i not "%CONFIRM%"=="SI" (
    echo.
    echo Operación cancelada.
    pause
    exit /b 0
)

echo.
echo Deteniendo contenedores y eliminando volúmenes...
echo ================================================
docker compose -f docker-compose-run.yml down -v

echo.
echo ================================================
echo Factory Reset completado.
echo Todos los contenedores y volúmenes han sido eliminados.
echo ================================================
pause

endlocal
