#!/bin/bash

SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
cd "$SCRIPT_DIR"

echo "================================================"
echo "  SMUL Personal - Factory Reset"
echo "================================================"
echo ""
echo "ADVERTENCIA: Esta operacion eliminara TODOS los datos"
echo "incluyendo bases de datos y volumenes de Docker!"
echo "================================================"
echo ""

if ! command -v docker &> /dev/null
then
    echo "ERROR: Docker no está instalado o no está ejecutándose!"
    echo "Por favor instala Docker y asegúrate de que esté ejecutándose."
    echo ""
    read -p "Presiona Enter para salir..."
    exit 1
fi

if [ ! -f "docker-compose-run.yml" ]; then
    echo "ERROR: docker-compose-run.yml no encontrado!"
    echo "Por favor asegúrate de ejecutar este script desde el directorio correcto."
    echo ""
    read -p "Presiona Enter para salir..."
    exit 1
fi

read -p "¿Estás seguro de que quieres continuar? (escriba 'SI' para confirmar): " CONFIRM
if [ "$CONFIRM" != "SI" ]; then
    echo ""
    echo "Operación cancelada."
    read -p "Presiona Enter para salir..."
    exit 0
fi

echo ""
echo "Deteniendo contenedores y eliminando volúmenes..."
echo "================================================"
docker compose -f docker-compose-run.yml down -v

echo ""
echo "================================================"
echo "Factory Reset completado."
echo "Todos los contenedores y volúmenes han sido eliminados."
echo "================================================"
read -p "Presiona Enter para salir..."
