@echo off
setlocal

set SCRIPT_DIR=%~dp0
cd /d "%SCRIPT_DIR%"

echo ================================================
echo   SMUL Personal - Inicio de Docker Compose
echo ================================================
echo.

docker --version >nul 2>&1
if errorlevel 1 (
    echo ERROR: Docker no está instalado o no está ejecutándose!
    echo Por favor instala Docker Desktop y asegúrate de que esté ejecutándose.
    echo.
    pause
    exit /b 1
)

if not exist "docker-compose-run.yml" (
    echo ERROR: docker-compose-run.yml no encontrado!
    echo Por favor asegúrate de ejecutar este script desde el directorio correcto.
    echo.
    pause
    exit /b 1
)


echo Iniciando Docker Compose...
echo.
echo NOTA: Cierra esta ventana para detener todos los contenedores
echo ================================================
echo.

docker compose -f docker-compose-run.yml up

echo.
echo ================================================
echo Deteniendo contenedores...
echo ================================================
docker compose -f docker-compose-run.yml down

echo.
echo Todos los contenedores han sido detenidos.
pause

endlocal
